/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import rpgboss.model.EntitySpec$;
import rpgboss.model.SpriteSpec;
import rpgboss.model.SpriteSpec$Directions$;
import rpgboss.model.SpriteSpec$Steps$;
import rpgboss.model.event.EventHeight$;
import rpgboss.model.resource.Spriteset;
import rpgboss.model.resource.Tileset$;
import rpgboss.player.Finishable;
import rpgboss.player.MapAndAssets;
import rpgboss.player.MutateQueue;
import rpgboss.player.MutateQueueItem;
import rpgboss.player.entity.BoundingBox;
import rpgboss.player.entity.Entity$;
import rpgboss.player.entity.EntityLike;
import rpgboss.player.entity.EntityMove;
import rpgboss.player.entity.PlayerEntity;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$mcZI$sp;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.math.Ordering$Float$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rMv!B\u0001\u0003\u0011\u0003I\u0011AB#oi&$\u0018P\u0003\u0002\u0004\t\u00051QM\u001c;jifT!!\u0002\u0004\u0002\rAd\u0017-_3s\u0015\u00059\u0011a\u0002:qO\n|7o]\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0001\u000e\u0005\u0019)e\u000e^5usN\u00111B\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bUYA\u0011\u0001\f\u0002\rqJg.\u001b;?)\u0005I\u0001\"\u0002\r\f\t\u0003I\u0012A\u00053fM\u0006,H\u000e^#oi&$\u0018p\u00159fK\u0012,\u0012A\u0007\t\u0003\u001fmI!\u0001\b\t\u0003\u000b\u0019cw.\u0019;\t\u000byYA\u0011A\u0010\u0002\u0019\u001d,G\u000fR5sK\u000e$\u0018n\u001c8\u0015\u0005\u0001\u001a\u0003CA\b\"\u0013\t\u0011\u0003CA\u0002J]RDQ\u0001J\u000fA\u0002\u0015\n1A^3d!\t1s&D\u0001(\u0015\tA\u0013&\u0001\u0003nCRD'B\u0001\u0016,\u0003\r9G\r\u001f\u0006\u0003Y5\n\u0001BY1eY><\u0017n\u0019\u0006\u0002]\u0005\u00191m\\7\n\u0005A:#a\u0002,fGR|'O\r\u0005\be-\t\n\u0011\"\u00014\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\tAG\u000b\u0002\u001bk-\na\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003wA\t!\"\u00198o_R\fG/[8o\u0013\ti\u0004HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DqaP\u0006\u0012\u0002\u0013\u00051'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\u000e\u0005\b\u0003.\t\n\u0011\"\u0001C\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\t1I\u000b\u0002!k!9QiCI\u0001\n\u00031\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'F\u0001HU\tAU\u0007E\u0002\u0010\u0013.K!A\u0013\t\u0003\r=\u0003H/[8o!\tau*D\u0001N\u0015\tqe!A\u0003n_\u0012,G.\u0003\u0002Q\u001b\nQ1\u000b\u001d:ji\u0016\u001c\u0006/Z2\u0007\u000b1\u0011\u0011\u0011\u0001*\u0014\u0007Es1\u000b\u0005\u0002\u000b)&\u0011QK\u0001\u0002\u000b\u000b:$\u0018\u000e^=MS.,\u0007\u0002C,R\u0005\u0003\u0005\u000b\u0011\u0002-\u0002\u0015M\u0004(/\u001b;fg\u0016$8\u000f\u0005\u0003Z9~\u0013gBA\b[\u0013\tY\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u00131!T1q\u0015\tY\u0006\u0003\u0005\u0002ZA&\u0011\u0011M\u0018\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015l\u0015\u0001\u0003:fg>,(oY3\n\u0005\u001d$'!C*qe&$Xm]3u\u0011!I\u0017K!A!\u0002\u0013Q\u0017AE7ba\u0006sG-Q:tKR\u001cx\n\u001d;j_:\u00042aD%l!\taW.D\u0001\u0005\u0013\tqGA\u0001\u0007NCB\fe\u000eZ!tg\u0016$8\u000f\u0003\u0005q#\n\u0005\t\u0015!\u0003r\u0003-\tG\u000e\\#oi&$\u0018.Z:\u0011\tI,\bE^\u0007\u0002g*\u0011A\u000fE\u0001\u000bG>dG.Z2uS>t\u0017BA/t!\tQ\u0011\u000b\u0003\u0005y#\n\u0005\r\u0011\"\u0001\u001a\u0003\u0005A\b\u0002\u0003>R\u0005\u0003\u0007I\u0011A>\u0002\u000ba|F%Z9\u0015\u0005q|\bCA\b~\u0013\tq\bC\u0001\u0003V]&$\b\u0002CA\u0001s\u0006\u0005\t\u0019\u0001\u000e\u0002\u0007a$\u0013\u0007C\u0005\u0002\u0006E\u0013\t\u0011)Q\u00055\u0005\u0011\u0001\u0010\t\u0005\n\u0003\u0013\t&\u00111A\u0005\u0002e\t\u0011!\u001f\u0005\u000b\u0003\u001b\t&\u00111A\u0005\u0002\u0005=\u0011!B=`I\u0015\fHc\u0001?\u0002\u0012!I\u0011\u0011AA\u0006\u0003\u0003\u0005\rA\u0007\u0005\n\u0003+\t&\u0011!Q!\ni\t!!\u001f\u0011\t\u0015\u0005e\u0011K!a\u0001\n\u0003\tY\"A\u0002eSJ,\u0012\u0001\t\u0005\u000b\u0003?\t&\u00111A\u0005\u0002\u0005\u0005\u0012a\u00023je~#S-\u001d\u000b\u0004y\u0006\r\u0002\"CA\u0001\u0003;\t\t\u00111\u0001!\u0011%\t9#\u0015B\u0001B\u0003&\u0001%\u0001\u0003eSJ\u0004\u0003BCA\u0016#\n\u0005\r\u0011\"\u0001\u0002.\u0005i\u0011N\\5uS\u0006d7\u000b\u001d:ji\u0016,\u0012\u0001\u0013\u0005\u000b\u0003c\t&\u00111A\u0005\u0002\u0005M\u0012!E5oSRL\u0017\r\\*qe&$Xm\u0018\u0013fcR\u0019A0!\u000e\t\u0013\u0005\u0005\u0011qFA\u0001\u0002\u0004A\u0005\"CA\u001d#\n\u0005\t\u0015)\u0003I\u00039Ig.\u001b;jC2\u001c\u0006O]5uK\u0002Ba!F)\u0005\u0002\u0005uBc\u0004<\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\t\r]\u000bY\u00041\u0001Y\u0011\u0019I\u00171\ba\u0001U\"1\u0001/a\u000fA\u0002ED\u0001\u0002_A\u001e!\u0003\u0005\rA\u0007\u0005\n\u0003\u0013\tY\u0004%AA\u0002iA\u0011\"!\u0007\u0002<A\u0005\t\u0019\u0001\u0011\t\u0013\u0005-\u00121\bI\u0001\u0002\u0004A\u0005bBA(#\u0012\u0005\u0011\u0011K\u0001\ra2\f\u00170\u001a:F]RLG/_\u000b\u0003\u0003'\u00022ACA+\u0013\r\t9F\u0001\u0002\r!2\f\u00170\u001a:F]RLG/\u001f\u0005\b\u00037\nf\u0011AA\u000e\u0003\u0019AW-[4ii\"1\u0011qL)\u0005\u0002e\t\u0011B\u001f)sS>\u0014\u0018\u000e^=\t\u000f\u0005\r\u0014K\"\u0001\u0002\u001c\u00059AO]5hO\u0016\u0014\bbBA4#\u0012\u0005\u0011\u0011N\u0001\tSN\u0004F.Y=feV\u0011\u00111\u000e\t\u0004\u001f\u00055\u0014bAA8!\t9!i\\8mK\u0006t\u0007bBA:#\u0012\u0005\u0011\u0011N\u0001\fG>dG.[:j_:|e\u000eC\u0004\u0002xE#\t!!\u001b\u0002\u0013%tg+\u001a5jG2,\u0007bBA>#\u0012\u0005\u00111D\u0001\fS:4V\r[5dY\u0016LE\rC\u0004\u0002\u0000E#\t!!!\u0002\u0011\u0005\u001cG/\u001b<bi\u0016$B!a!\u0002\fB!q\"SAC!\ra\u0017qQ\u0005\u0004\u0003\u0013#!A\u0003$j]&\u001c\b.\u00192mK\"9\u0011QRA?\u0001\u0004\u0001\u0013aE1di&4\u0018\r^8sg\u0012K'/Z2uS>t\u0007\"CAI#\n\u0007I\u0011BAJ\u0003%iwN^3Rk\u0016,X-\u0006\u0002\u0002\u0016B!A.a&w\u0013\r\tI\n\u0002\u0002\f\u001bV$\u0018\r^3Rk\u0016,X\r\u0003\u0005\u0002\u001eF\u0003\u000b\u0011BAK\u0003)iwN^3Rk\u0016,X\r\t\u0005\b\u0003C\u000bF\u0011AA5\u00039iwN^3Rk\u0016,X-R7qifD\u0011\"!*R\u0001\u0004%\t\"a*\u0002\u001b5|g/Z:F]F,X-^3e+\t\tI\u000bE\u0002\u0010\u0003WK1!!,\u0011\u0005\u0011auN\\4\t\u0013\u0005E\u0016\u000b1A\u0005\u0012\u0005M\u0016!E7pm\u0016\u001cXI\\9vKV,Gm\u0018\u0013fcR\u0019A0!.\t\u0015\u0005\u0005\u0011qVA\u0001\u0002\u0004\tI\u000b\u0003\u0005\u0002:F\u0003\u000b\u0015BAU\u00039iwN^3t\u000b:\fX/Z;fI\u0002B\u0001\"!0R\u0001\u0004%\t!G\u0001\u0006gB,W\r\u001a\u0005\n\u0003\u0003\f\u0006\u0019!C\u0001\u0003\u0007\f\u0011b\u001d9fK\u0012|F%Z9\u0015\u0007q\f)\rC\u0005\u0002\u0002\u0005}\u0016\u0011!a\u00015!9\u0011\u0011Z)!B\u0013Q\u0012AB:qK\u0016$\u0007\u0005C\u0005\u0002NF\u0003\r\u0011\"\u0003\u0002j\u0005Y\u0011n]'pm&twMV1s\u0011%\t\t.\u0015a\u0001\n\u0013\t\u0019.A\bjg6{g/\u001b8h-\u0006\u0014x\fJ3r)\ra\u0018Q\u001b\u0005\u000b\u0003\u0003\ty-!AA\u0002\u0005-\u0004\u0002CAm#\u0002\u0006K!a\u001b\u0002\u0019%\u001cXj\u001c<j]\u001e4\u0016M\u001d\u0011\t\u0013\u0005u\u0017\u000b1A\u0005\n\u0005\u001d\u0016aC7pm&twmU5oG\u0016D\u0011\"!9R\u0001\u0004%I!a9\u0002\u001f5|g/\u001b8h'&t7-Z0%KF$2\u0001`As\u0011)\t\t!a8\u0002\u0002\u0003\u0007\u0011\u0011\u0016\u0005\t\u0003S\f\u0006\u0015)\u0003\u0002*\u0006aQn\u001c<j]\u001e\u001c\u0016N\\2fA!I\u0011Q^)A\u0002\u0013%\u00111D\u0001\n[N\u0004VM]*uKBD\u0011\"!=R\u0001\u0004%I!a=\u0002\u001b5\u001c\b+\u001a:Ti\u0016\u0004x\fJ3r)\ra\u0018Q\u001f\u0005\n\u0003\u0003\ty/!AA\u0002\u0001Bq!!?RA\u0003&\u0001%\u0001\u0006ngB+'o\u0015;fa\u0002B\u0011\"!@R\u0001\u0004%\t!a@\u0002\u0013M\u0004(/\u001b;fg\u0016$X#\u00012\t\u0013\t\r\u0011\u000b1A\u0005\u0002\t\u0015\u0011!D:qe&$Xm]3u?\u0012*\u0017\u000fF\u0002}\u0005\u000fA\u0011\"!\u0001\u0003\u0002\u0005\u0005\t\u0019\u00012\t\u000f\t-\u0011\u000b)Q\u0005E\u0006Q1\u000f\u001d:ji\u0016\u001cX\r\u001e\u0011\t\u0013\t=\u0011\u000b1A\u0005\u0002\u0005m\u0011!C:qe&$X-\u00133y\u0011%\u0011\u0019\"\u0015a\u0001\n\u0003\u0011)\"A\u0007taJLG/Z%eq~#S-\u001d\u000b\u0004y\n]\u0001\"CA\u0001\u0005#\t\t\u00111\u0001!\u0011\u001d\u0011Y\"\u0015Q!\n\u0001\n!b\u001d9sSR,\u0017\n\u001a=!\u0011!\u0011y\"\u0015a\u0001\n\u0003I\u0012\u0001C4sCBD\u0017nY,\t\u0013\t\r\u0012\u000b1A\u0005\u0002\t\u0015\u0012\u0001D4sCBD\u0017nY,`I\u0015\fHc\u0001?\u0003(!I\u0011\u0011\u0001B\u0011\u0003\u0003\u0005\rA\u0007\u0005\b\u0005W\t\u0006\u0015)\u0003\u001b\u0003%9'/\u00199iS\u000e<\u0006\u0005\u0003\u0005\u00030E\u0003\r\u0011\"\u0001\u001a\u0003!9'/\u00199iS\u000eD\u0005\"\u0003B\u001a#\u0002\u0007I\u0011\u0001B\u001b\u000319'/\u00199iS\u000eDu\fJ3r)\ra(q\u0007\u0005\n\u0003\u0003\u0011\t$!AA\u0002iAqAa\u000fRA\u0003&!$A\u0005he\u0006\u0004\b.[2IA!I!qH)A\u0002\u0013\u0005\u00111D\u0001\ngRLG\u000e\\*uKBD\u0011Ba\u0011R\u0001\u0004%\tA!\u0012\u0002\u001bM$\u0018\u000e\u001c7Ti\u0016\u0004x\fJ3r)\ra(q\t\u0005\n\u0003\u0003\u0011\t%!AA\u0002\u0001BqAa\u0013RA\u0003&\u0001%\u0001\u0006ti&dGn\u0015;fa\u0002B\u0001Ba\u0014R\u0001\u0004%\t!G\u0001\u0014E>,h\u000eZ5oO\n{\u0007\u0010S1mMNL'0\u001a\u0005\n\u0005'\n\u0006\u0019!C\u0001\u0005+\nqCY8v]\u0012Lgn\u001a\"pq\"\u000bGNZ:ju\u0016|F%Z9\u0015\u0007q\u00149\u0006C\u0005\u0002\u0002\tE\u0013\u0011!a\u00015!9!1L)!B\u0013Q\u0012\u0001\u00062pk:$\u0017N\\4C_bD\u0015\r\u001c4tSj,\u0007\u0005\u0003\u0004\u0003`E#\t!G\u0001\u001dE>,h\u000eZ5oO\n{\u0007\u0010S1mMNL'0\u001a+pY\u0016\u0014\u0018M\\2f\u0011\u001d\u0011\u0019'\u0015C\u0001\u0005K\n\u0001\"[:N_ZLgn\u001a\u000b\u0003\u0003WB\u0011B!\u001bR\u0005\u0004%\tAa\u001b\u0002\u0013QLg\u000e^\"pY>\u0014XC\u0001B7!\u0011\u0011yG!\u001e\u000e\u0005\tE$b\u0001B:S\u0005AqM]1qQ&\u001c7/\u0003\u0003\u0003x\tE$!B\"pY>\u0014\b\u0002\u0003B>#\u0002\u0006IA!\u001c\u0002\u0015QLg\u000e^\"pY>\u0014\b\u0005C\u0004\u0003\u0000E#\tA!!\u0002\u0019M,G\u000fV5oi\u000e{Gn\u001c:\u0015\t\t5$1\u0011\u0005\t\u0005\u000b\u0013i\b1\u0001\u0003n\u0005)1m\u001c7pe\"9!\u0011R)\u0005\u0002\t-\u0015AF:fi\n{WO\u001c3j]\u001e\u0014u\u000e\u001f%bY\u001a\u001c\u0018N_3\u0015\u0007q\u0014i\tC\u0004\u0003\u0010\n\u001d\u0005\u0019\u0001\u000e\u0002\u0017!\fGNZ:ju\u0016\f%o\u001a\u0005\b\u0005'\u000bF\u0011\u0001BK\u000399W\r\u001e\"pk:$\u0017N\\4C_b$\"Aa&\u0011\u0007)\u0011I*C\u0002\u0003\u001c\n\u00111BQ8v]\u0012Lgn\u001a\"pq\"9!qT)\u0005\u0002\t\u0005\u0016AF4fi\u0012K'/Z2uS>tWK\\5u-\u0016\u001cGo\u001c:\u0015\u0005\t\r\u0006#B\b\u0003&jQ\u0012b\u0001BT!\t1A+\u001e9mKJBqAa+R\t\u0003\u0011i+\u0001\thKRl\u0015\r]\"pY2L7/[8ogRA!q\u0016BY\u0005k\u0013I\f\u0005\u0004\u0010\u0005K\u000bY\u0007\t\u0005\b\u0005g\u0013I\u000b1\u0001\u001b\u0003\u0015!\u00070\u0011:h\u0011\u001d\u00119L!+A\u0002i\tQ\u0001Z=Be\u001eD\u0001\"a\u001e\u0003*\u0002\u0007\u00111\u000e\u0005\b\u0005{\u000bF\u0011\u0001B`\u0003)\u0019\u0017M\\*uC:$\u0017\t\u001e\u000b\u0007\u0003W\u0012\tM!2\t\u000f\t\r'1\u0018a\u00015\u0005\u0011A\r\u001f\u0005\b\u0005\u000f\u0014Y\f1\u0001\u001b\u0003\t!\u0017\u0010\u0003\u0004\u0003LF#\t!G\u0001\u0010G>dG.[:j_:$U\r\u001c;bg\"9!qZ)\u0005\u0002\tE\u0017aC2veJ,g\u000e^*uKB$\u0012\u0001\t\u0005\b\u0005+\fF\u0011\u0001Bl\u0003%\u0019X\r^*qe&$X\rF\u0002}\u00053DqAa7\u0003T\u0002\u0007\u0001*\u0001\u0006taJLG/Z*qK\u000eDqAa8R\t\u0003\u0011\t/\u0001\nhKR\fE\u000e\\#wK:$Hk\\;dQ\u0016\u001cHC\u0002Br\u0005S\u0014Y\u000f\u0005\u0003s\u0005K4\u0018b\u0001Btg\nA\u0011\n^3sC\ndW\rC\u0004\u00034\nu\u0007\u0019\u0001\u000e\t\u000f\t]&Q\u001ca\u00015!9!q^)\u0005\u0002\tE\u0018aC3ocV,W/Z'pm\u0016$2\u0001 Bz\u0011!\u0011)P!<A\u0002\t]\u0018\u0001B7pm\u0016\u0004B\u0001\u001cB}m&\u0019!1 \u0003\u0003\u001f5+H/\u0019;f#V,W/Z%uK6DqAa@R\t\u0003\u0019\t!\u0001\u0006n_Z,WI\u001c;jif$baa\u0001\u0004\n\r-\u0001c\u0001\u0006\u0004\u0006%\u00191q\u0001\u0002\u0003\u0015\u0015sG/\u001b;z\u001b>4X\r\u0003\u0004%\u0005{\u0004\r!\n\u0005\t\u0007\u001b\u0011i\u00101\u0001\u0002l\u0005q\u0011M\u001a4jq\u0012K'/Z2uS>t\u0007bBB\t#\u0012\u000511C\u0001\u0013[>4X-Q<bs\u001a\u0013x.\\#oi&$\u0018\u0010F\u0003}\u0007+\u00199\u0002C\u0004\u0002P\r=\u0001\u0019\u0001<\t\u0011\r51q\u0002a\u0001\u0003WBqaa\u0007R\t\u0003\u0019i\"A\u0007u_V\u001c\u0007.\u00128uSRLWm\u001d\u000b\u0004y\u000e}\u0001\u0002CB\u0011\u00073\u0001\raa\t\u0002\u001fQ|Wo\u00195fI\u0016sG/\u001b;jKN\u0004Ra!\n\u00046YtAaa\n\u000429!1\u0011FB\u0018\u001b\t\u0019YCC\u0002\u0004.!\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0007\rM\u0002#A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d8q\u0007\u0006\u0004\u0007g\u0001\u0002bBB\u001e#\u0012\u00051QH\u0001\t_:\u0014U\u000f\u001e;p]R\tA\u0010C\u0004\u0004BE#\taa\u0011\u0002\u000f\rdwn]3tiV!1QIB&)!\u00199ea\u0016\u0004^\r}\u0003\u0003BB%\u0007\u0017b\u0001\u0001\u0002\u0005\u0004N\r}\"\u0019AB(\u0005\u0005!\u0016cAB)mB\u0019qba\u0015\n\u0007\rU\u0003CA\u0004O_RD\u0017N\\4\t\u0011\re3q\ba\u0001\u00077\n\u0001\"\u001a8uSRLWm\u001d\t\u0007\u0007K\u0019)da\u0012\t\u0013\t\r7q\bI\u0001\u0002\u0004Q\u0002\"\u0003Bd\u0007\u007f\u0001\n\u00111\u0001\u001b\u0011\u001d\u0019\u0019'\u0015C\u0001\u0007K\nAdZ3u)>,8\r[5oO\u0006sGM\u00117pG.LgnZ#wK:$8\u000f\u0006\u0005\u0004h\r%41NB7!\u001dy!Q\u0015Br\u0003WBqAa1\u0004b\u0001\u0007!\u0004C\u0004\u0003H\u000e\u0005\u0004\u0019\u0001\u000e\t\u0011\r=4\u0011\ra\u0001\u0003W\n\u0011bY8mY&\u001c\u0018n\u001c8\t\u000f\rM\u0014\u000b\"\u0001\u0004v\u00051Q\u000f\u001d3bi\u0016$R\u0001`B<\u0007wBqa!\u001f\u0004r\u0001\u0007!$A\u0003eK2$\u0018\r\u0003\u0005\u0004~\rE\u0004\u0019AA6\u00035)g/\u001a8ug\u0016s\u0017M\u00197fI\"91\u0011Q)\u0005\u0002\r\r\u0015A\u0002:f]\u0012,'\u000fF\u0003}\u0007\u000b\u001b)\n\u0003\u0005\u0004\b\u000e}\u0004\u0019ABE\u0003\u0015\u0011\u0017\r^2i!\u0011\u0019Yi!%\u000e\u0005\r5%\u0002BBH\u0005c\n1a\u001a\u001ae\u0013\u0011\u0019\u0019j!$\u0003\u0017M\u0003(/\u001b;f\u0005\u0006$8\r\u001b\u0005\t\u0007/\u001by\b1\u0001\u0004\u001a\u0006a\u0011\r\u001e7bgN\u0003(/\u001b;fgB!11RBN\u0013\u0011\u0019ij!$\u0003\u0019Q+\u0007\u0010^;sK\u0006#H.Y:\t\u000f\r\u0005\u0016K\"\u0001\u0004>\u00059A-[:q_N,\u0007\"CBS#F\u0005I\u0011ABT\u0003E\u0019Gn\\:fgR$C-\u001a4bk2$HEM\u000b\u0004g\r%F\u0001CB'\u0007G\u0013\raa\u0014\t\u0013\r5\u0016+%A\u0005\u0002\r=\u0016!E2m_N,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u00191g!-\u0005\u0011\r531\u0016b\u0001\u0007\u001f\u0002")
public abstract class Entity
implements EntityLike {
    public final scala.collection.immutable.Map<String, Spriteset> rpgboss$player$entity$Entity$$spritesets;
    private final Option<MapAndAssets> mapAndAssetsOption;
    private final Map<Object, Entity> allEntities;
    private float x;
    private float y;
    private int dir;
    private Option<SpriteSpec> initialSprite;
    private final MutateQueue<Entity> moveQueue;
    private long movesEnqueued;
    private float speed;
    private boolean isMovingVar;
    private long movingSince;
    private int msPerStep;
    private Spriteset spriteset;
    private int spriteIdx;
    private float graphicW;
    private float graphicH;
    private int stillStep;
    private float boundingBoxHalfsize;
    private final Color tintColor;

    public static Option<SpriteSpec> $lessinit$greater$default$7() {
        return Entity$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return Entity$.MODULE$.$lessinit$greater$default$6();
    }

    public static float $lessinit$greater$default$5() {
        return Entity$.MODULE$.$lessinit$greater$default$5();
    }

    public static float $lessinit$greater$default$4() {
        return Entity$.MODULE$.$lessinit$greater$default$4();
    }

    public static int getDirection(Vector2 vector2) {
        return Entity$.MODULE$.getDirection(vector2);
    }

    public static float defaultEntitySpeed() {
        return Entity$.MODULE$.defaultEntitySpeed();
    }

    @Override
    public float x() {
        return this.x;
    }

    public void x_$eq(float x$1) {
        this.x = x$1;
    }

    @Override
    public float y() {
        return this.y;
    }

    public void y_$eq(float x$1) {
        this.y = x$1;
    }

    public int dir() {
        return this.dir;
    }

    public void dir_$eq(int x$1) {
        this.dir = x$1;
    }

    public Option<SpriteSpec> initialSprite() {
        return this.initialSprite;
    }

    public void initialSprite_$eq(Option<SpriteSpec> x$1) {
        this.initialSprite = x$1;
    }

    public PlayerEntity playerEntity() {
        return (PlayerEntity)this.allEntities.apply(BoxesRunTime.boxToInteger(EntitySpec$.MODULE$.playerEntityId()));
    }

    public abstract int height();

    public float zPriority() {
        Enumeration.Value value2;
        block5: {
            int n;
            block3: {
                block4: {
                    block2: {
                        value2 = EventHeight$.MODULE$.apply(this.height());
                        Enumeration.Value value3 = EventHeight$.MODULE$.UNDER();
                        Enumeration.Value value4 = value2;
                        if (value3 != null ? !((Object)value3).equals(value4) : value4 != null) break block2;
                        n = -10;
                        break block3;
                    }
                    Enumeration.Value value5 = EventHeight$.MODULE$.SAME();
                    Enumeration.Value value6 = value2;
                    if (value5 != null ? !((Object)value5).equals(value6) : value6 != null) break block4;
                    n = 0;
                    break block3;
                }
                Enumeration.Value value7 = EventHeight$.MODULE$.OVER();
                Enumeration.Value value8 = value2;
                if (value7 != null ? !((Object)value7).equals(value8) : value8 != null) break block5;
                n = 10;
            }
            int zAdjustment = n;
            return this.y() + (float)zAdjustment;
        }
        throw new MatchError(value2);
    }

    public abstract int trigger();

    public boolean isPlayer() {
        return false;
    }

    public boolean collisionOn() {
        return true;
    }

    public boolean inVehicle() {
        return false;
    }

    public int inVehicleId() {
        return -1;
    }

    public Option<Finishable> activate(int activatorsDirection) {
        return None$.MODULE$;
    }

    private MutateQueue<Entity> moveQueue() {
        return this.moveQueue;
    }

    public boolean moveQueueEmpty() {
        return this.moveQueue().isEmpty();
    }

    public long movesEnqueued() {
        return this.movesEnqueued;
    }

    public void movesEnqueued_$eq(long x$1) {
        this.movesEnqueued = x$1;
    }

    @Override
    public float speed() {
        return this.speed;
    }

    public void speed_$eq(float x$1) {
        this.speed = x$1;
    }

    private boolean isMovingVar() {
        return this.isMovingVar;
    }

    private void isMovingVar_$eq(boolean x$1) {
        this.isMovingVar = x$1;
    }

    private long movingSince() {
        return this.movingSince;
    }

    private void movingSince_$eq(long x$1) {
        this.movingSince = x$1;
    }

    private int msPerStep() {
        return this.msPerStep;
    }

    private void msPerStep_$eq(int x$1) {
        this.msPerStep = x$1;
    }

    public Spriteset spriteset() {
        return this.spriteset;
    }

    public void spriteset_$eq(Spriteset x$1) {
        this.spriteset = x$1;
    }

    public int spriteIdx() {
        return this.spriteIdx;
    }

    public void spriteIdx_$eq(int x$1) {
        this.spriteIdx = x$1;
    }

    public float graphicW() {
        return this.graphicW;
    }

    public void graphicW_$eq(float x$1) {
        this.graphicW = x$1;
    }

    public float graphicH() {
        return this.graphicH;
    }

    public void graphicH_$eq(float x$1) {
        this.graphicH = x$1;
    }

    public int stillStep() {
        return this.stillStep;
    }

    public void stillStep_$eq(int x$1) {
        this.stillStep = x$1;
    }

    public float boundingBoxHalfsize() {
        return this.boundingBoxHalfsize;
    }

    public void boundingBoxHalfsize_$eq(float x$1) {
        this.boundingBoxHalfsize = x$1;
    }

    public float boundingBoxHalfsizeTolerance() {
        return 0.1f;
    }

    public boolean isMoving() {
        return this.isMovingVar();
    }

    public Color tintColor() {
        return this.tintColor;
    }

    public Color setTintColor(Color color) {
        return this.tintColor().set(color);
    }

    public void setBoundingBoxHalfsize(float halfsizeArg) {
        float halfsize = package$.MODULE$.min((2.0f - this.collisionDeltas()) / 2.0f, halfsizeArg);
        this.boundingBoxHalfsize_$eq(halfsize - this.boundingBoxHalfsizeTolerance());
    }

    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.x() - this.boundingBoxHalfsize(), this.y() - this.boundingBoxHalfsize(), this.x() + this.boundingBoxHalfsize(), this.y() + this.boundingBoxHalfsize());
    }

    public Tuple2<Object, Object> getDirectionUnitVector() {
        int n;
        block6: {
            Tuple2<Object, Object> tuple2;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            n = this.dir();
                            if (SpriteSpec$Directions$.MODULE$.NORTH() != n) break block2;
                            tuple2 = new Tuple2<Object, Object>(BoxesRunTime.boxToFloat(0.0f), BoxesRunTime.boxToFloat(-1.0f));
                            break block3;
                        }
                        if (SpriteSpec$Directions$.MODULE$.SOUTH() != n) break block4;
                        tuple2 = new Tuple2<Float, Float>(BoxesRunTime.boxToFloat(0.0f), BoxesRunTime.boxToFloat(1.0f));
                        break block3;
                    }
                    if (SpriteSpec$Directions$.MODULE$.EAST() != n) break block5;
                    tuple2 = new Tuple2<Float, Float>(BoxesRunTime.boxToFloat(1.0f), BoxesRunTime.boxToFloat(0.0f));
                    break block3;
                }
                if (SpriteSpec$Directions$.MODULE$.WEST() != n) break block6;
                tuple2 = new Tuple2<Float, Float>(BoxesRunTime.boxToFloat(-1.0f), BoxesRunTime.boxToFloat(0.0f));
            }
            return tuple2;
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public Tuple2<Object, Object> getMapCollisions(float dxArg, float dyArg, boolean inVehicle) {
        return this.mapAndAssetsOption.map(new Serializable(this, dxArg, dyArg, inVehicle){
            private final /* synthetic */ Entity $outer;
            private final float dxArg$1;
            private final float dyArg$1;
            private final boolean inVehicle$1;

            public final Tuple2<Object, Object> apply(MapAndAssets mapAndAssets) {
                return mapAndAssets.getCollisions(this.$outer, this.$outer.x(), this.$outer.y(), this.dxArg$1, this.dyArg$1, this.inVehicle$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dxArg$1 = dxArg$1;
                this.dyArg$1 = dyArg$1;
                this.inVehicle$1 = inVehicle$1;
            }
        }).getOrElse(new Serializable(this){

            public final Tuple2<Object, Object> apply() {
                return new Tuple2$mcZI$sp(true, 0);
            }
        });
    }

    public boolean canStandAt(float dx, float dy) {
        Tuple2<Object, Object> tuple2 = this.getMapCollisions(dx, dy, false);
        if (tuple2 != null) {
            Tuple2<Iterable<Entity>, Object> tuple22;
            boolean blocked = tuple2._1$mcZ$sp();
            boolean bl = blocked;
            boolean blocked2 = bl;
            if (blocked2) {
                return false;
            }
            int restoreVehicleId = -1;
            if (this.playerEntity().inVehicle()) {
                restoreVehicleId = this.playerEntity().inVehicleId();
                this.playerEntity().setInVehicle(false, 0);
            }
            if ((tuple22 = this.getTouchingAndBlockingEvents(dx, dy, true)) != null) {
                boolean evtBlocked;
                boolean bl2;
                boolean evtBlocked2 = bl2 = (evtBlocked = tuple22._2$mcZ$sp());
                if (restoreVehicleId >= 0) {
                    this.playerEntity().setInVehicle(true, restoreVehicleId);
                }
                return !evtBlocked2;
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public float collisionDeltas() {
        return 0.05f;
    }

    public int currentStep() {
        int n;
        if (this.isMovingVar()) {
            long movingDuration = System.currentTimeMillis() - this.movingSince();
            int timeInCycle = (int)(movingDuration % (long)(this.msPerStep() * SpriteSpec$Steps$.MODULE$.TOTALSTEPS()));
            int stepNumber = timeInCycle / this.msPerStep() + 1;
            n = (this.stillStep() + stepNumber) % SpriteSpec$Steps$.MODULE$.TOTALSTEPS();
        } else {
            n = this.stillStep();
        }
        return n;
    }

    public void setSprite(Option<SpriteSpec> spriteSpec) {
        spriteSpec.map(new Serializable(this){
            private final /* synthetic */ Entity $outer;

            public final void apply(SpriteSpec s2) {
                this.$outer.spriteset_$eq((Spriteset)this.$outer.rpgboss$player$entity$Entity$$spritesets.apply(s2.name()));
                this.$outer.spriteIdx_$eq(s2.spriteIndex());
                this.$outer.graphicW_$eq((float)((double)this.$outer.spriteset().tileW() / (double)Tileset$.MODULE$.tilesize()));
                this.$outer.graphicH_$eq((float)((double)this.$outer.spriteset().tileH() / (double)Tileset$.MODULE$.tilesize()));
                this.$outer.setBoundingBoxHalfsize((this.$outer.graphicW() - this.$outer.collisionDeltas()) * 0.5f);
                if (!this.$outer.isPlayer()) {
                    this.$outer.dir_$eq(s2.dir());
                }
                this.$outer.stillStep_$eq(s2.step());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse(new Serializable(this){
            private final /* synthetic */ Entity $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.spriteset_$eq(null);
                this.$outer.setBoundingBoxHalfsize((1.0f - this.$outer.collisionDeltas()) * 0.5f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Iterable<Entity> getAllEventTouches(float dxArg, float dyArg) {
        BoundingBox boundingBox = this.getBoundingBox().offsetted(dxArg, dyArg);
        return (Iterable)((TraversableLike)this.allEntities.values().filter(new Serializable(this, boundingBox){
            private final BoundingBox boundingBox$1;

            public final boolean apply(Entity npc) {
                return npc.getBoundingBox().contains(this.boundingBox$1);
            }
            {
                this.boundingBox$1 = boundingBox$1;
            }
        })).filter(new Serializable(this){
            private final /* synthetic */ Entity $outer;

            public final boolean apply(Entity x$1) {
                Entity entity = x$1;
                Entity entity2 = this.$outer;
                return entity != null ? !entity.equals(entity2) : entity2 != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void enqueueMove(MutateQueueItem<Entity> move) {
        this.moveQueue().enqueue(move);
        this.movesEnqueued_$eq(this.movesEnqueued() + 1L);
    }

    public EntityMove moveEntity(Vector2 vec, boolean affixDirection) {
        if (vec.x != 0.0f || vec.y != 0.0f) {
            if (!affixDirection) {
                this.dir_$eq(Entity$.MODULE$.getDirection(vec));
            }
            EntityMove move = new EntityMove(vec);
            this.enqueueMove(move);
            return move;
        }
        return null;
    }

    public void moveAwayFromEntity(Entity playerEntity, boolean affixDirection) {
        float xDiff = this.x() - playerEntity.x();
        float yDiff = this.y() - playerEntity.y();
        int xMove = 0;
        int yMove = 0;
        if (xDiff > 0.0f) {
            xMove = 1;
        }
        if (xDiff < 0.0f) {
            xMove = -1;
        }
        if (yDiff > 0.0f) {
            yMove = 1;
        }
        if (yDiff < 0.0f) {
            yMove = -1;
        }
        Vector2 vec = new Vector2(xMove, yMove);
        if (!affixDirection) {
            this.dir_$eq(Entity$.MODULE$.getDirection(vec));
        }
        EntityMove move = new EntityMove(vec);
        this.enqueueMove(move);
    }

    public void touchEntities(Iterable<Entity> touchedEntities) {
    }

    public void onButton() {
    }

    public <T extends Entity> T closest(Iterable<T> entities, float dx, float dy) {
        Predef$.MODULE$.assert(!entities.isEmpty());
        return (T)((Entity)entities.minBy(new Serializable(this, dx, dy){
            private final /* synthetic */ Entity $outer;
            private final float dx$1;
            private final float dy$1;

            public final float apply(T e) {
                return package$.MODULE$.abs(((Entity)e).x() - (this.$outer.x() + this.dx$1)) + package$.MODULE$.abs(((Entity)e).y() - (this.$outer.y() + this.dy$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dx$1 = dx$1;
                this.dy$1 = dy$1;
            }
        }, Ordering$Float$.MODULE$));
    }

    public <T extends Entity> float closest$default$2() {
        return 0.0f;
    }

    public <T extends Entity> float closest$default$3() {
        return 0.0f;
    }

    public Tuple2<Iterable<Entity>, Object> getTouchingAndBlockingEvents(float dx, float dy, boolean collision) {
        Iterable evtsTouched = (Iterable)this.getAllEventTouches(dx, dy).filter((Function1<Entity, Object>)((Object)new Serializable(this){
            private final /* synthetic */ Entity $outer;

            public final boolean apply(Entity x$2) {
                Entity entity = x$2;
                Entity entity2 = this.$outer;
                return entity != null ? !entity.equals(entity2) : entity2 != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        boolean evtBlocking = collision && this.height() == EventHeight$.MODULE$.SAME().id() && evtsTouched.exists(new Serializable(this){

            public final boolean apply(Entity x$3) {
                return x$3.height() == EventHeight$.MODULE$.SAME().id();
            }
        });
        return new Tuple2<Iterable<Entity>, Object>(evtsTouched, BoxesRunTime.boxToBoolean(evtBlocking));
    }

    public void update(float delta, boolean eventsEnabled) {
        if (this.moveQueue().isEmpty()) {
            this.isMovingVar_$eq(false);
        } else {
            if (!this.isMovingVar()) {
                this.isMovingVar_$eq(true);
                this.movingSince_$eq(System.currentTimeMillis());
            }
            this.moveQueue().runQueueItem(delta);
        }
    }

    public void render(SpriteBatch batch, TextureAtlas atlasSprites) {
        if (this.spriteset() != null) {
            float dstOriginX = this.x() - this.graphicW() / 2.0f;
            float dstOriginY = this.y() - this.graphicH() + this.graphicW() / (float)2;
            this.spriteset().renderSprite(batch, atlasSprites, this.spriteIdx(), this.dir(), this.currentStep(), dstOriginX, dstOriginY, this.graphicW(), this.graphicH());
            batch.setColor(this.tintColor());
            this.spriteset().renderSprite(batch, atlasSprites, this.spriteIdx(), this.dir(), this.currentStep(), dstOriginX, dstOriginY, this.graphicW(), this.graphicH());
            batch.setColor(Color.WHITE);
        }
    }

    public abstract void dispose();

    public Entity(scala.collection.immutable.Map<String, Spriteset> spritesets, Option<MapAndAssets> mapAndAssetsOption, Map<Object, Entity> allEntities, float x, float y, int dir, Option<SpriteSpec> initialSprite) {
        this.rpgboss$player$entity$Entity$$spritesets = spritesets;
        this.mapAndAssetsOption = mapAndAssetsOption;
        this.allEntities = allEntities;
        this.x = x;
        this.y = y;
        this.dir = dir;
        this.initialSprite = initialSprite;
        this.moveQueue = new MutateQueue<Entity>(this);
        this.movesEnqueued = 0L;
        this.speed = Entity$.MODULE$.defaultEntitySpeed();
        this.isMovingVar = false;
        this.movingSince = 0L;
        this.msPerStep = 128;
        this.spriteset = null;
        this.spriteIdx = -1;
        this.graphicW = 0.0f;
        this.graphicH = 0.0f;
        this.stillStep = SpriteSpec$Steps$.MODULE$.STILL();
        this.boundingBoxHalfsize = 0.5f;
        this.tintColor = Color.WHITE.cpy();
        this.setBoundingBoxHalfsize(0.5f);
    }
}

